function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 122);

T(1) = (params(2)-1)/params(2);
T(2) = (1-params(11))*exp(T(1)*y(50));
T(3) = exp(y(13))^params(3);
T(4) = exp(y(45));
T(5) = T(4)^(1-params(3));
T(6) = T(3)*T(5);
T(7) = T(6)^T(1);
T(8) = exp(y(42));
T(9) = T(2)*T(7)+params(11)*T(8)^T(1);
T(10) = params(2)/(params(2)-1);
T(11) = 1/params(2);
T(12) = exp(y(43))^T(11);
T(13) = (-1)/params(2);
T(14) = T(8)^T(13);
T(15) = T(12)*exp(T(1)*y(50))*(1-params(11))*(1-params(3));
T(16) = T(6)^T(13);
T(17) = T(4)^(-params(3));
T(18) = T(12)*exp(T(1)*y(50))*(1-params(11))*params(3);
T(19) = exp(y(13))^(params(3)-1);
T(20) = exp(y(44));
T(21) = params(9)^((-1)/params(8));
T(22) = 1/params(8);
T(23) = exp(y(115));
T(24) = exp(y(49));
T(25) = exp(y(46))-params(9)*T(4)^(1+params(8))/(1+params(8));
T(26) = T(25)^(-params(14));
T(27) = exp(y(15))-params(9)*exp(y(14))^(1+params(8))/(1+params(8));
T(28) = T(27)^(-params(14));
T(29) = params(13)^(1-params(4));
T(30) = params(24)^(1-params(4));
T(31) = params(12)^(1-params(4));
T(32) = exp(y(31));
T(33) = exp(y(53))+exp(y(32))+T(32);
T(34) = exp(y(52))+exp(y(30))+exp(y(29));
T(35) = exp(y(3))+exp(y(2))+exp(y(17));
T(36) = exp(y(5))+exp(y(4))+exp(y(18));
T(37) = T(26)*exp(y(28))*T(32);
T(38) = params(25)^(-1);
T(39) = T(38)*y(22)*(-(T(24)*exp(y(28))*exp(y(11))));
T(40) = T(38)*y(25)*(-(T(24)*exp(y(28))*exp(y(56))));
T(41) = y(83)*(-exp(y(28)))+exp(y(28))*y(69)+T(39)+T(38)*y(24)*(-(exp(y(28))*T(24)))+T(40);
T(42) = exp(y(29))/T(34);
T(43) = exp(y(30))/T(34);
T(44) = exp(y(28))*T(32)-T(32)*params(6)*exp(y(65)-y(51))^(params(5)-1);
T(45) = T(32)/T(33);
T(46) = exp(y(32))/T(33);
T(47) = params(25)*y(135)*(-(exp(y(33))*exp((-y(117)))*exp(y(37))));
T(48) = exp(y(33))*y(86)+params(25)*y(125)*exp(y(33))*params(6)*exp(params(5)*y(37))+params(25)*y(129)*(-(exp(y(33))*(1-exp((-y(117)))*exp(y(37)))))+T(47);
T(49) = params(25)*y(133)*(-(exp(y(38))*exp(y(34))));
T(50) = exp(y(34))*y(84)+params(25)*y(125)*params(6)*exp(params(5)*y(38))*exp(y(34))+params(25)*y(127)*(-((1-exp(y(38)))*exp(y(34))))+T(49);
T(51) = exp(y(35))*y(89)+y(86)*(-(params(7)*exp(y(35))))+params(25)*y(132)*(-((1-params(7))*exp(y(35))));
T(52) = exp(y(36))*y(87)+y(84)*(-(params(7)*exp(y(36))))+params(25)*y(130)*(-((1-params(7))*exp(y(36))));
T(53) = params(25)*y(129)*(-(exp(y(33))*(-(exp((-y(117)))*exp(y(37))))));
T(54) = T(47)+params(25)*y(125)*exp(y(33))*params(6)*params(5)*exp(params(5)*y(37))+T(53);
T(55) = T(23)*params(6)*params(5)*(params(5)-1)*exp(y(38)*(params(5)-1));
T(56) = (-(T(23)*(exp(y(38))*exp(y(107))+y(108)*(-exp(y(38)))-params(6)*params(5)*exp(params(5)*y(38)))));
T(57) = params(25)*y(127)*(-(exp(y(34))*(-exp(y(38)))));
T(58) = T(8)*getPowerDeriv(T(8),T(13),1);
T(59) = T(8)*getPowerDeriv(T(8),T(1),1);
T(60) = getPowerDeriv(T(9),T(10),1);
T(61) = exp(y(43))*getPowerDeriv(exp(y(43)),T(11),1);
T(62) = exp(T(1)*y(50))*(1-params(11))*params(3)*T(61);
T(63) = exp(T(1)*y(50))*(1-params(11))*(1-params(3))*T(61);
T(64) = (1-params(11))*exp(T(1)*y(116));
T(65) = exp(y(112))^(1-params(3));
T(66) = T(20)*getPowerDeriv(T(20),params(3),1);
T(67) = T(20)^params(3);
T(68) = T(65)*T(67);
T(69) = getPowerDeriv(T(68),T(1),1);
T(70) = T(64)*T(65)*T(66)*T(69);
T(71) = T(68)^T(1);
T(72) = T(64)*T(71)+params(11)*exp(y(110))^T(1);
T(73) = getPowerDeriv(T(72),T(10),1);
T(74) = exp(y(112))^(-params(3));
T(75) = exp(y(111))^T(11);
T(76) = T(75)*(1-params(11))*(1-params(3))*exp(T(1)*y(116));
T(77) = T(68)^T(13);
T(78) = getPowerDeriv(T(68),T(13),1);
T(79) = T(65)*T(66)*T(78);
T(80) = T(20)^(params(3)-1);
T(81) = T(75)*(1-params(11))*params(3)*exp(T(1)*y(116));
T(82) = T(20)*getPowerDeriv(T(20),params(3)-1,1);
T(83) = (-(T(65)*(T(80)*T(79)*T(81)+T(77)*T(81)*T(82))));
T(84) = T(4)*getPowerDeriv(T(4),1+params(8),1);
T(85) = (-(params(9)*T(84)/(1+params(8))));
T(86) = getPowerDeriv(T(25),(-params(14)),1);
T(87) = T(85)*T(86);
T(88) = (1-params(3))*exp(y(45)*(1-params(3)));
T(89) = (-(exp(T(1)*y(50))*exp(y(13)*params(3))*T(88)));
T(90) = T(4)*getPowerDeriv(T(4),1-params(3),1);
T(91) = getPowerDeriv(T(6),T(13),1);
T(92) = T(3)*T(90)*T(91);
T(93) = (-(T(16)*T(18)*T(19)*T(90)+T(5)*T(19)*T(18)*T(92)));
T(94) = T(4)*getPowerDeriv(T(4),(-params(3)),1);
T(95) = (-(T(17)*T(3)*T(15)*T(92)+T(3)*T(15)*T(16)*T(94)));
T(96) = getPowerDeriv(T(6),T(1),1);
T(97) = T(2)*T(3)*T(90)*T(96);
T(98) = exp(y(113))-params(9)*exp(y(112))^(1+params(8))/(1+params(8));
T(99) = params(1)*T(98)^(-params(14));
T(100) = exp(y(46))*T(86);
T(101) = (-(params(1)*T(100)/T(28)));
T(102) = exp(y(48))*getPowerDeriv(exp(y(48)),T(22),1);
T(103) = T(38)*y(24)*(T(24)*params(6)*params(5)*exp(y(11)*(params(5)-1))-T(24)*(exp(y(28))-y(40)))+T(24)*y(75)+T(38)*y(21)*(-(T(24)*(1+exp(y(47))-params(10))))+T(38)*y(22)*(-(T(24)*(exp(y(28))*exp(y(11))+y(40)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))))+T(38)*y(23)*(-(y(41)*T(24)*(1-params(7))))+T(38)*y(25)*(-(T(24)*(exp(y(28))*exp(y(56))+y(57)*(1-exp(y(56)))-params(22)*exp(params(21)*y(56)))))+T(38)*y(26)*(-(y(58)*T(24)*(1-params(23))));
T(104) = T(12)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50));
T(105) = T(12)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50));
T(106) = (1-params(11))*T(1)*exp(T(1)*y(50));
T(107) = T(7)*T(106);
T(108) = params(25)^2;
T(109) = getPowerDeriv(exp(y(65)-y(51)),params(5)-1,1);
T(110) = (-(T(32)*params(6)*(-exp(y(65)-y(51)))*T(109)));
T(111) = T(26)*T(110);
T(112) = (-(exp(y(6))*exp(y(10))*(-exp((-y(51))))));
T(113) = (-(exp(y(6))*(-(exp(y(10))*(-exp((-y(51))))))));
T(114) = y(92)*T(112)+y(86)*T(113);
T(115) = exp(y(52))/T(34);
T(116) = exp(y(53))/T(33);
T(117) = exp(y(54))*y(85)+params(25)*y(125)*params(22)*exp(params(21)*y(118))*exp(y(54))+params(25)*y(128)*(-((1-exp(y(118)))*exp(y(54))))+params(25)*y(134)*(-(exp(y(118))*exp(y(54))));
T(118) = exp(y(55))*y(88)+y(85)*(-(params(23)*exp(y(55))))+params(25)*y(131)*(-((1-params(23))*exp(y(55))));
T(119) = (-(exp(y(19))*exp(y(56))));
T(120) = (-(exp(y(19))*(-exp(y(56)))));
T(121) = T(38)*y(25)*(-(T(24)*(exp(y(28))*exp(y(56))+y(57)*(-exp(y(56)))-params(22)*params(21)*exp(params(21)*y(56)))));
T(122) = (-(T(32)*params(6)*exp(y(65)-y(51))*T(109)));

end
